// UpperPanel.h: Interface for Class CUpperPanel.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_UPPERPANEL_H__794E0C3C_C7D7_42CA_81D3_AD9547289A76__INCLUDED_)
#define AFX_UPPERPANEL_H__794E0C3C_C7D7_42CA_81D3_AD9547289A76__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Panel.h"

const int NUM_RADAR_SCALES = 16;

class CUpperPanel : public CPanel  
{
	enum {SURF_SWITCH2, SURF_SWITCH3, SURF_SWITCH4, SURF_INDICATOR1, 
		SURF_INDICATOR2, SURF_TANKCONFIG, SURF_CARGOCONFIG, SURF_NO_TANK, 
		SURF_OPENVALVE, SURF_RADAR_ON, SURF_RADAR_MALFUNCTION, SURF_FUELPUMPLVL, NUMSURFACES};
	static const int sc_arriThrustValvesY[9];
public:
	void SetRadarScaleIndex(int iRadarScaleIndex);
	int m_iRadarScaleIndex;
	static const double s_arrdRadarScales[NUM_RADAR_SCALES];
	void RedrawPanel_Radar(SURFHANDLE sh);
	virtual bool Redraw(int iID, int iEvent, SURFHANDLE sh);
	virtual bool MouseEvent(int iID, int iEvent, int iX, int iY);
	virtual void Init();
	virtual bool Load();
	CUpperPanel(VESSEL* pVessel, int iPanelID);
	virtual ~CUpperPanel();
	enum  
	{
		AID_THR_FLOWLEVELS,     
		AID_THRGRP_VALVES,
		AID_EXT_TANK_VLVFLOW1,
		AID_EXT_TANK_VLVFLOW2,
		AID_EXT_TANK_VLVFLOW3,
		AID_EXT_TANK_VLVFLOW4,
		AID_EXT_TANK1,     
		AID_EXT_TANK2,     
		AID_EXT_TANK3,     
		AID_EXT_TANK4,     
		AID_INT_TANK,     
		AID_RCS_TANK,   
		AID_FUEL_DOCKPORT, 
		AID_FUEL_HATCHVENT, 
		AID_FUEL_RCSPIPE,
		AID_FUELPUMP,
		AID_AIRLOCK1SWITCH,  
		AID_AIRLOCK1INDICATOR,
		AID_DOCKSWITCH,      
		AID_DOCKINDICATOR,
		AID_NAVLIGHT_SWITCH, 
		AID_BCNLIGHT_SWITCH, 
		AID_STRBLIGHT_SWITCH, 
		AID_SHIPSCHEME,
		AID_RADAR,
		NUM_AREANAMES
	};
	static const WORD sc_pwBmpResIDs[NUMSURFACES];

private:
	void RedrawPanel_Fuelstatus (SURFHANDLE sh, int iPart);
};

#endif // !defined(AFX_UPPERPANEL_H__794E0C3C_C7D7_42CA_81D3_AD9547289A76__INCLUDED_)

