// ==============================================================
//                 ORBITER MODULE:  ShuttleA2
//			Modification by Alexander Blass 2003 - 2004
//			based on ShuttleA (C) 2002 Martin Schweiger
//
// ShuttleA.h
// Class interface for Shuttle-A vessel class module
// ==============================================================

#ifndef __SHUTTLEA_H
#define __SHUTTLEA_H

#include "orbitersdk.h"
#include "MovableThruster.h"
#include "Panel.h"
#include "MainPanel.h"
#include "FuelManagement.h"	
#include "Radar.h"

// ==========================================================
// Some vessel class caps
// ==========================================================

const double EMPTY_MASS = 9600.0;
// Empty mass (excluding fuel) [kg]

const double FRONT_PART_MASS = 5400.0;
const double REAR_PART_MASS = EMPTY_MASS-FRONT_PART_MASS;
// Empty mass of the rear and front shuttle parts in case of a Breakup

const double STABILIZER_MASS = 100.0;
// mass of two stabilizer bars used at empty cargoslots

const double TANK_MASS = 400.0;
// mass of two external tanks (excluding fuel)

const double CARGO_MASS = 400.0;
// mass of two cargo containers (excluding cargo)

const double INT_TANK_FUEL = 3200.0;
// fuel capacity of internal tank

const double EXT_TANK_FUEL = 12800.0;
// fuel capacity of two external tanks

const double MAX_MAIN_FUEL = 16000.0;
// Max fuel capacity: main tank [kg]

const double MAX_RCS_FUEL = 700.0;
// Max fuel capacity: RCS tank [kg]

const double MAX_MAIN_THRUST = 193520.0;
// Main engine thrust [N] per engine

const double MAX_HOVER_THRUST = 135450.0;
// Hover engine thrust [N] per engine

const double MAX_RETRO_THRUST = 60000.0;
// Max thrust [N] of retro/hover pods per engine

const double MAX_RCS_THRUST = 2500.0;
// Max thrust [N] for each attitude thruster

const double ISP = 3e4;
// Vacuum Isp (fuel-specific impulse) for all thrusters [m/s]

const double DOCK_OPERATING_SPEED = 0.05;
// Opening/closing speed of docking hatch mechanism (1/sec)
// => cycle = 20 sec

const double AIRLOCK_OPERATING_SPEED = 0.1;
// Opening/closing speed of outer airlock (1/sec)
// => cycle = 10 sec

const double CARGOSLOTOFFSET_X = 1.76;
// X Offset for positioning the Cargocontainers/Tanks

const double CARGOSLOTOFFSET_Z[4] = {9.117, 3.796, -3.748, -9.067};
// Y Offset for every row of Cargocontainers/Tanks

// Crosssections for the empty mesh and 
// pairs of tanks/containers/stabilizers 
const VECTOR3 CRSSEC_EMPTY_SHUTTLE = {91.8, 105.0, 38.4};
const VECTOR3 CRSSEC_CARGO = {10.55, 34.0, 4.0};
const VECTOR3 CRSSEC_STABILIZER = {2.2, 4.4, 0.0};
const VECTOR3 CRSSEC_TANK = {8.85, 30.0, 2.0};



// ==========================================================
// Interface for derived vessel class: ShuttleA
// ==========================================================

class ShuttleA: public VESSEL {
	friend class CMainPanel;
	friend class CUpperPanel;
	friend class CFuelManagement;
public:
	int ConsumeKey(char *keystate);
	bool m_bHandleHoverKeys;
	double m_dOldHoverLvl;
	bool m_bHullTempAlarm;
	void SetHullTempAlarm(bool bAlarm);
	double m_dHullTemp;
	char* BuildFilename(char* chEnd, int iCargSlot = -1);
	char * m_arrMeshesCargoSlots[4];
	char m_chMeshShuttle[256];
	double m_arrdCargoWeights[4];
	void SetStrbLight(bool bOn);
	void SetBcnLight(bool bOn);
	void SetNavLight(bool bOn);
	bool m_bNavLight;
	bool m_bBcnLight;
	bool m_bStrbLight;
	enum {LGT_RIGHT, LGT_LEFT, LGT_AFT, LGT_RIGHT_STRB, LGT_LEFT_STRB, LGT_AFT_STRB, LGT_TOP_BCN, LGT_BTM_BCN, NUM_LIGHTS};
	THRUSTER_HANDLE m_thLights[NUM_LIGHTS];
	void CreateLights();
	bool IsLanded();
	void AddParticleStreams();
	VECTOR3 m_vecLastHorzAirSpd;
	void SetRadDmgAlarm(bool bAlarm);
	bool m_bRadDmgAlarm;
	bool m_bShuttleBroken;
	void CreateRearPart();
	void CreateCargObj(int iType, bool bLeft = true, double dLoadMass = 0.0);
	void BreakUp(bool bOnInit = false);
	bool m_bThrDmgAdded;
	bool m_bOvrSpdAlarm;
	bool m_bDmgAlarm;
	bool GetDmgAlarm();
	void SetDmgAlarm(bool bAlarm);
	bool GetOvrSpeedAlarm();
	void SetOvrSpeedAlarm(bool bAlarm);
	void VisualDestroyed(VISHANDLE vh);
	void Animate(double dSimTime);
	void VisualCreated(VISHANDLE vh);
	VISHANDLE m_vh;
	void AuxPodDamage();
	MESHHANDLE m_arrmhCargoSlots[8];
	void WreckRadar();
	void AddMeshes(bool bReload = false);
	int m_iLeftAuxPodMsh, m_iRadarMsh;
	MESHHANDLE m_mhLeftAuxPodDmg, m_mhRadarWrk;
	void CreateThrusters();
	CFuelManagement m_FuelManage;
	int ConsumeBufferedKey(DWORD dwKey, bool bDown, char* kstate);
	void Navmode(int iMode, bool bActive);
	void MFDmode(int iMfd, int iMode);
	bool PanelMouseEvent(int iID, int iEvent, int iX, int iY);
	bool RedrawPanel(int iID, int iEvent, SURFHANDLE sh);
	bool LoadPanel(int iID);
	CPanel* m_pPanels[2];
	void InitCargoSlots();
	void ToggleAuxThrustMode(int iButton);
	void AssignAuxPodsGroup(UINT uiGroup);
	ShuttleA (OBJHANDLE hObj, int fmodel);
	~ShuttleA ();
	void SetClassCaps (FILEHANDLE cfg);
	void LoadState (FILEHANDLE scn, void *vs);
	void SaveState (FILEHANDLE scn);
	void PostCreation ();
	void Timestep (double simt);
	void RotatePod (UINT which, UINT mode);

	SURFHANDLE shContrailBlue;
	THRUSTER_HANDLE th_main[4], th_hover[4], th_pod[2], m_arrthAtt[14];
	UINT podswitch[2];
	double dock_proc, lock_proc;
	enum DoorStatus { DOOR_CLOSED, DOOR_OPEN, DOOR_CLOSING, DOOR_OPENING } dock_status, lock_status;

	void ActivateDockingPort (DoorStatus action);
	void RevertDockingPort ();
	void ActivateAirlock (DoorStatus action);
	void RevertAirlock ();
	enum {EMPTY, TANK, CARGO};

protected:
	enum {USER, RETRO, HOVER, MAIN, MOVETO_RETRO, MOVETO_HOVER, MOVETO_MAIN};
	UINT AuxPodsState();
	UINT m_uiCurPodsGroup;
	int m_arriCargoConf[4];
	int m_iNumExtTanks;
	double m_dOverSpeed;
	CRadar* m_pRadar;
	bool m_bAuxPodDmg;

private:
	void DefineAnimations ();
	PSTREAM_HANDLE m_hpsEmissHover[2];
	PSTREAM_HANDLE m_hpsDiffHover[2];
	PSTREAM_HANDLE m_hpsEmissAux[2];
	PSTREAM_HANDLE m_hpsDiffAux[2];
	PSTREAM_HANDLE m_hpsEmissMain[2];
	PSTREAM_HANDLE m_hpsDiffMain[2];
	THGROUP_HANDLE thg_main, thg_hover, thg_pod, thg_retro;
	UINT anim_dock, anim_lock;
	CMovableThruster* m_arrpAuxThrusters[2];
	SURFHANDLE m_hExhPtclTex;
	SURFHANDLE m_hLightGreenTex;
	SURFHANDLE m_hLightRedTex;
};

typedef struct {
	HINSTANCE hDLL;
	HFONT hFont[1];
	HPEN hPen[3];
	HBRUSH hBrush[4];
} GDIParams;

// global helper functions
bool GetBlinkStatus(double dFrequ = 1.0, double dPulseWidth = 0.5, double dOffset = 0.0);

#define MSHGRP_OuterAirlock 18
#define MSHGRP_UpperDockingHatch 36
#define MSHGRP_LowerDockingHatch 37
#define MSHGRP_AuxThrusterGridRight 50
#define MSHGRP_AuxThrusterHousingRight 51
#define MSHGRP_AuxThrusterLitRight 52
#define MSHGRP_AuxThrusterRight 59


#define MSHGRP_AuxThrusterLeft 0
#define MSHGRP_AuxThrusterLitLeft 1
#define MSHGRP_AuxThrusterHousingLeft 2
#define MSHGRP_AuxThrusterGridLeft 3

#define MSHGRP_RadarAxisPiece 0
#define MSHGRP_Radar_Hold 1
#define MSHGRP_Radar_Pod 2

extern int g_iSoundBase;

#define SND_LCD_BEEP (0 + g_iSoundBase) 
#define SND_OVRSPD_ALARM (1 + g_iSoundBase)
#define SND_DMG_ALARM (2 + g_iSoundBase)
#define SND_VIBRATION (3 + g_iSoundBase)
#define SND_VIBRATION_HEAVY (4 + g_iSoundBase)
#define SND_DMG_BREAK (5 + g_iSoundBase)
#define SND_DMG_AUX (6 + g_iSoundBase)
#define NUM_SOUNDS 7

#endif // !__SHUTTLEA_H