// Panel.h: Interface for Class CPanel.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PANEL_H__88D1005D_A4CC_45B9_93B1_5115E67D5DC8__INCLUDED_)
#define AFX_PANEL_H__88D1005D_A4CC_45B9_93B1_5115E67D5DC8__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "orbitersdk.h"

class CPanel  
{
public:
	void TriggerRedrawArea(int iIndex);
	int GetPanelID();
	virtual bool Redraw(int iID, int iEvent, SURFHANDLE sh) = 0;
	virtual bool MouseEvent(int iID, int iEvent, int iX, int iY) = 0;
	virtual void Init() = 0;
	virtual bool Load() = 0;
	CPanel(VESSEL* pVessel, int iPanelID, int iNumAreaIDs, const WORD* pwResIDs, int iNumResIDs);
	virtual ~CPanel();

protected:
	int m_iPanelID;
	SURFHANDLE SurfHandle(int iIndex);
	int AreaID(int iIndex);
	int AreaIndex(int iID);
	VESSEL* m_pVessel;
private:
	int m_iIDFirst, m_iIDLast;
	static int s_iNextAreaID;
	SURFHANDLE* m_pSurfHandles;
	int m_iNumSurfHandles;
};

#endif // !defined(AFX_PANEL_H__88D1005D_A4CC_45B9_93B1_5115E67D5DC8__INCLUDED_)
