// Panel.cpp: Implementation of Class CPanel.
//
//////////////////////////////////////////////////////////////////////

#include "Panel.h"
#include "ShuttleA.h"

extern GDIParams g_Param;

int CPanel::s_iNextAreaID = 40;

CPanel::CPanel(VESSEL* pVessel, int iPanelID, int iNumAreaIDs, const WORD* pwResIDs, int iNumResIDs)
{
	m_pVessel = pVessel;

	m_iIDFirst = s_iNextAreaID;
	s_iNextAreaID += iNumAreaIDs;
	m_iIDLast = s_iNextAreaID - 1;

	m_pSurfHandles = new SURFHANDLE [iNumResIDs];
	for(int iIndex = 0;iIndex < iNumResIDs;iIndex++)
		m_pSurfHandles[iIndex] = oapiCreateSurface(LoadBitmap(g_Param.hDLL, MAKEINTRESOURCE(pwResIDs[iIndex])));
	m_iNumSurfHandles = iNumResIDs; 
	m_iPanelID = iPanelID;
}

CPanel::~CPanel()
{
	for(int iIndex = 0;iIndex < m_iNumSurfHandles;iIndex++)
		oapiDestroySurface(m_pSurfHandles[iIndex]);
	delete m_pSurfHandles;
}

int CPanel::AreaID(int iIndex)
{
	return iIndex + m_iIDFirst;
}

SURFHANDLE CPanel::SurfHandle(int iIndex)
{
	return m_pSurfHandles[iIndex];
}

int CPanel::AreaIndex(int iID)
{
	if(iID >= m_iIDFirst && iID <= m_iIDLast)
		return iID - m_iIDFirst;
	else
		return -1;
}

int CPanel::GetPanelID()
{
	return m_iPanelID;
}

void CPanel::TriggerRedrawArea(int iIndex)
{
	oapiTriggerPanelRedrawArea(m_iPanelID, AreaID(iIndex));
}
