// MovableThruster.h: Schnittstelle fr die Klasse CMovableThruster.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_MOVABLETHRUSTER_H__5A3B4D88_B021_4718_9C81_234153CA9C90__INCLUDED_)
#define AFX_MOVABLETHRUSTER_H__5A3B4D88_B021_4718_9C81_234153CA9C90__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "orbitersdk.h"

const double MAX_ROT_SPEED = PI/15;
const double THRUSTROTACCEL = PI/15;

class CMovableThruster  
{
public:
	
	MGROUP_ROTATE* m_pMeshGroupRotate;
	double m_dWholeAngle;
	ANIMATIONCOMPONENT_HANDLE m_hAnimComp;
	double m_dLastAnimDir;
	void BreakUp();
	bool m_bShuttleBroken;
	VECTOR3 GetPos();
	VECTOR3 GetThrustDirVec();
	void Animate(double dSimTime);
	void VisualDestroyed(VISHANDLE vh);
	void VisualCreated(VISHANDLE vh);
	VISHANDLE m_vh;
	double m_dAnimAngle;
	void RotateNewMeshToThrDir();
	double m_dMeshToAnimAngle;
	bool m_bAnimRegistered;
	void MeshChanged(int iNewMeshID);
	void SetExhaustParams(double dLength, double dWidth, double dDist);
	void ChangePosAndDir(VECTOR3 vecPos, VECTOR3 vecMeshThrustDir);
	void RotateStop();
	void RotateBackward();
	void RotateForward();
	void AddThrustDirWant(double dDirDelta);
	void PostCreation();
	double GetThrustLevel();
	void SetThrustLevel(double dThrLevel);
	void ForceThrustDir(double dThrDir);
	double GetThrustDirWant();
	double GetThrustDir();
	THRUSTER_HANDLE GetThrHandle();
	void SetThrustDirWant(double dDirWant);
	virtual void AddExhaust();
	virtual void RegisterAnimation(UINT* puiMeshGroups, int iNumGroups, int iMesh = 0);
	virtual THRUSTER_HANDLE Create(PROPELLANT_HANDLE m_ph, SURFHANDLE shExhaustTex = NULL);
	virtual bool Timestep(double dSimtimeDelta);
	CMovableThruster(VESSEL* pVessel, VECTOR3 vecPos, 
		double dMaxThrust, double dISP, VECTOR3 vecMeshThrustDir, 
		double dMinAngle, double dMaxAngle, int iRotAxis,
		double dExhaustLength, double dExhaustWidth, double dExhaustDist);
	virtual ~CMovableThruster();
	enum {X, Y, Z};

protected:
	int m_iMeshID;
	UINT m_uiExhID;
	void CalcThrustDirVec();
	SURFHANDLE m_shExhaustTex;
	VESSEL* m_pVessel;
	VECTOR3 m_vecThrustDir;
	VECTOR3 m_vecMeshThrustDir;
	double m_dExhaustDist;
	double m_dExhaustWidth;
	double m_dExhaustLength;
	UINT* m_puiMeshGroups;
	int m_iNumGroups;
	ANIMCOMP m_anmcRot;
	UINT m_uiAnimSeq;
	int m_iRotAxis;
	double m_dMaxAngle;
	double m_dMinAngle;
	PROPELLANT_HANDLE m_ph;
	double m_dISP;
	double m_dMaxThrust;
	THRUSTER_HANDLE m_th;
	VECTOR3 m_vecPos;
	double m_dThrDir;
	double m_dThrDirWant;
	double m_dThrRotSpeed;
	enum{MOVE_TO, MOVE_FORWARD, MOVE_BACKWARD};
	UINT m_uiMode;
};

#endif // !defined(AFX_MOVABLETHRUSTER_H__5A3B4D88_B021_4718_9C81_234153CA9C90__INCLUDED_)
